		save
	if DontListIncls
		listing off
	endif

;********************************************************************
;
; This file contains definitions for 341-0080-B
;
; 2002-11-24 PS
; last changes 2014-01-23 PS
;
;********************************************************************


Stack_Top 	EQU 080h		; Register 07Fh +1



;********************************************************************
; Hardware
;********************************************************************
;
;	I/O Port	Use
;	--------	---
;	   0		Bit 0: Adr8
;	{Output}	Bit 1: Adr9
;			Bit 2: Adr10 
;			Bit 3: PreComp  (precomp / reduce write current)
;			Bit 4: PHIB2  (step motor phases)
;			Bit 5: PHIB1
;			Bit 6: PHIA2
;			Bit 7: PHIA1
;
;	   1 		Bit 0: Adr0 
;    {Input/Output}	Bit 1: Adr1 
;			Bit 2: Adr2 
;			Bit 3: Adr3
;			Bit 4: Adr4 
;			Bit 5: Adr5 
;			Bit 6: Adr6 
;			Bit 7: Adr7
;
;	   2 		Bit 0: WRTSMI  (write sector mark input)
;    {Input/Output}	Bit 1: Trk0  (track 0 input)
;			Bit 2: CMD  (command input)
;			Bit 3: BSY  (busy output)
;			Bit 4: Msel0
;			Bit 5: Msel1  (1=disk, 0=host)
;			Bit 6: DSTART
;			Bit 7: DRW  (disk read=1 / write=0)
;
;	   3		Bit 0: FastSeek  (=1 for fast seek)
;    {Input/Output}	Bit 1: SectorMark (sector pulse input)
;			Bit 2: Index (index pulse input)
;			Bit 3: CRCERR (=0 if error detected)
;			Bit 4: HS0
;			Bit 5: HS1
;			Bit 6: WRTSM  (write sector mark output)
;			Bit 7: RDHDR/TX
;

; Port 0 Defs:
PreComp	 	EQU 008h	; Write Pre-compensation
PHIB2	 	EQU 010h
PHIB1	 	EQU 020h	; step motor phases
PHIA2 		EQU 040h
PHIA1	 	EQU 080h

; Port 2 Defs:
SECTDN	 	EQU 001h	; =0 when state machine finished
Trk0 		EQU 002h	; track 0 input
CMD 		EQU 004h	; Apple CMD input
BSY 		EQU 008h	; Apple BUSY output
Msel0 		EQU 010h	; Memory Select bit 0
Msel1 		EQU 020h	; Memory Select bit 1
				;   00: Apple --> Mem
				;   01: Z8 --> Timer
				;   10: State Machine (Disk) --> Mem
				;   11: Z8 --> Mem
DSTART 		EQU 040h	; 
DRW_Read 	EQU 080h	; State Machine: Disk Read/Write

; Port 3 Defs:
FastSeek	EQU 001h	; =1 for fast, =0 for slow seek
SectorMark 	EQU 002h	; sector mark from analog board
Index	 	EQU 004h	; index pulse input from analog board
CRCERR		EQU 008h	; =0 if CRC error detected
HS0 		EQU 010h	; Head select
HS1 		EQU 020h	;
WRTSM		EQU 040h	; set 0 to write sector mark
RDHDR 		EQU 080h	; set 0 to read next header into RAM



;********************************************************************
; Registers
;********************************************************************

P3Mask1		EQU 004h	; WRTSM + RDHDR + Heads
P3Mask2		EQU 005h	; WRTSM + Heads
Status1   	EQU 006h	; these are the status bytes for the host
Status2   	EQU 007h
Status3   	EQU 008h
Status4         EQU 009h
CurStep   	EQU 00Ah	; step motor angle (0..7)
SpareTblDirty	EQU 00Ch	; <>0 when spare table needs to be updated
MaskChkHdr	EQU 00Dh	; don't check headers after seek when <>0
HostCommand	EQU 00Eh	; these are the command bytes from host
LBAhi	  	EQU 00Fh	;   logical block number hi
LBAmi	  	EQU 010h	;			 mid
LBAlo	  	EQU 011h	;			 low
LBA	  	EQU LBAmi	;   this is an word alias for LBAmi.LBAlo
RetryCnt  	EQU 012h	;   retry count (default=100)
SparingTh 	EQU 013h	;   sparing threshold
SpareMap_RW	EQU 014h	; <>0 when spare map accessed after ReadCHS, WriteCHS
DSM_FastTo	EQU 015h	; <>0 for fast disk state machine timeout
HeaderImage	EQU 016h	; sector header bytes: this byte always = 000h
ActCyl	  	EQU 017h	;   actual cylinder
ActHead   	EQU 018h	;          head
ActSector 	EQU 019h	;          sector
ComCyl	  	EQU 01Ah	;   complemented actual cylinder
ComHead   	EQU 01Bh	; 		        head
ComSector 	EQU 01Ch	; 		        sector
LastSublist	EQU 01Dh	; last spare table sublist used (=last LBAmi value)
SeekDir   	EQU 01Eh
StpMotOff 	EQU 01Fh	; <>0 if step motor off
DiskSM_Timeout	EQU 020h	; <>0 if disk state machine timeout
RWstat		EQU 021h	; this goes into Status1 
Cylinder  	EQU 022h	; cylinder from LBA translation
Head	  	EQU 023h	; head from LBA translation
OnTrackFlg	EQU 024h	; <>0 when heads have been moved
RetriesLeft	EQU 025h	; number of retries left for read operation (starts at RetryCount)
GoCHSRetry	EQU 027h	; retry counter for GoCHS routine
OnTrackCtr	EQU 028h	; counter for Seek_ChkHdr function
RAM_MSB		EQU 02Ah	; RAM MSB (010h or 013h)
HeaderBufLSB 	EQU 02Bh	; RAM LSB for state machine operation
StatusBufLSB	EQU 02Ch	; RAM LSB of status buffer address
ReReadGood	EQU 02Eh	; <>0 if ReRead did at least one successful read
SpMap_Lowest	EQU 02Fh	; lowest LBAlo in current subtable
SpMap_Highest	EQU 030h	; highest LBAlo in current subtable
SpMap_Read	EQU 031h	; <>0 when called from R/W or seek, =0 when called after sparing
SpMap_ReadToDo	EQU 032h	; <>0 if lookup has not been processed yet
PwrFlg0		EQU 033h	; =0FFh for warm start
PwrFlg1		EQU 034h	; =001h for warm start
SpareBlocks	EQU 035h	; number of spares allocated
BadBlocks 	EQU 036h        ; number of bad blocks
SeekDelay	EQU 037h	; delay in 0.64ms increments
CHSinvalid	EQU 038h	; <>0 if LBAtoCHS did not update Cylinder/Head/ActiveSector
BlockStat	EQU 039h 	; block to be entered into spare table is 040h = bad or 080h = spared
SpareTblInvalid	EQU 03Ah	; <>0 if spare table could not be read
FirstStep	EQU 03Bh	; =1 for the first motor step at seek
SettlingReqd	EQU 03Dh	; <>0 when we just moved the heads
ReReadMode	EQU 03Eh	; =0 to continue re-reading after first good read
BlockIsBad	EQU 03Fh 	; <>0 if the current block is a bad block
WorkingRegs	EQU 040h	; 040..04Fh are our working registers R0..R15



;********************************************************************
; External Ram Stuff
;********************************************************************

RAM		EQU 01000h
ReadBuffer	EQU 01014h
WriteBuffer	EQU 01028h
SpareMapFence	EQU 0123Dh	; should be 055h, 099h, 0AAh
;
; local spare map
;
SpareMap	EQU 01240h	; 026h two-byte byte pointers to the sublists
	; The spare map is a list with 026h two-byte entries, one for each 
	; LBAmi value. Each entry either contains FFFF (NIL) or points to
	; a sublist in memory. 
SpareMapEnd	EQU 0128Ch	; first free RAM address after the spare table
SpareSublists	EQU 0128Eh	; one sublist for each LBAmi value
	; The first byte of this sublist holds the number of two-byte entries
	; in this list. Each entry consists of the LBAlo value of the questionable
	; block, followed by a type byte. Bit 7 =1 indicates a spared block, bit 6 =1
	; indicates a bad block, and bit 4..0 indicate which spare track block is used.
;
SeekHeaderBuf	EQU 013E0h
HostCmdBuffer	EQU 013F0h	; host DMAs his commands here


;********************************************************************
; Constants
;********************************************************************

; *** System Status Definitions
;     Status1
Bad_55 		EQU 080h	; Status: Other than 55 response from host
WrBuf_OR 	EQU 040h	; Status: Write Buffer Overflow
Stat_SpTblUpd	EQU 020h	; Status: host data lost because spare table updated
Stat_Seek_Err	EQU 010h	; Status: Seek Error
Stat_Rd_Err	EQU 008h	; Status: Read Error
Stat_No_Hdr 	EQU 004h	; Status: No Header Found
Stat_nc1 	EQU 002h
Op_Failed 	EQU 001h	; Status: Operation Failed
;     Status2
Stat_Seek_Flt	EQU 080h	; Status: seek needed retry
SprTbl_Full 	EQU 040h	; Status: no room left in spare table
BadBkTbl_Full 	EQU 010h	; Status: bad block table overflow
Stat_SprTbl_Err	EQU 008h	; Status: unable to read status sector
Stat_Spare 	EQU 004h	; Status: Sparing has occured
Stat_Seek 	EQU 002h	; Status: Seek to wrong track
;     Status3
Power_Reset 	EQU 080h	; Profile was power reset
Illegal_Block 	EQU 040h	; Status: Block number out of bounds
;     Status4 holds the number of retries needed


; Spare Table offsets (relative to start of buffer)
ST_DeviceName	EQU 0		; "PROFILE      "
ST_DeviceType	EQU 13		; 000h, 000h, 000h
ST_FwRev	EQU 16		; 003h, 098h
ST_Capacity	EQU 18		; 000h, 026h, 000h
ST_BlockSize	EQU 21		; 002h, 014h
ST_SparesAvail	EQU 23		; 020h
ST_SparesAlloc	EQU 24	
ST_BadPending	EQU 25
ST_SpareMap	EQU 26		; length 76 bytes
ST_SpareMapEnd	EQU 102
ST_Sublists	EQU 106


	restore
